<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?= $title ?> | <?= $company['company_name'] ?> | <?= $company['sub_name'] ?></title>
    <link href="https://fonts.googleapis.com/css?family=Assistant:200,300,400,600,700,800|Playfair+Display:400,400i,500,500i,600,600i,700,700i,800,800i,900,900i&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url('assets/') ?>frontend/libraries/bootstrap/css/bootstrap.css">
    <link rel="stylesheet" href="<?= base_url('assets/') ?>frontend/styles/main.css">
    <link rel="shortcut icon" href="<?= base_url('assets/images/favicon.png') ?>">
</head>

<body>
    <!-- Navbar -->
    <div class="menu-bar">
        <div class="container">
            <nav class="row navbar navbar-expand-lg navbar-light ">
                <a href="<?= site_url('front') ?>" class="navbar-brand">
                    <img src="<?= base_url('assets/images/' . $company['logo']) ?>" alt="logo">
                </a>
                <button class="navbar-toggler navbar-toggler-right" type="button" data-toggle="collapse" data-target="#navb">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navb">
                    <ul class="navbar-nav ml-auto mr-3">
                        <li class="nav-item mx-md-2">
                            <a href="<?= site_url('front') ?>" class="nav-link <?= $title == 'Home' ? 'active' : '' ?>">Beranda</a>
                        </li>
                        <li>
                            <a href="<?= site_url('layanan.html') ?>" class="nav-link <?= $title == 'Produk Layanan' | $title == 'Detail Layanan' ? 'active' : '' ?>">Produk Layanan</a>
                        </li>

                        <li>
                            <a href="<?= site_url('tentang-kami.html') ?>" class="nav-link <?= $title == 'Tentang Kami' ? 'active' : '' ?>">About Us</a>
                        </li>
                        <!-- Mobile Button -->
                        <a href="<?= site_url('auth') ?>" style="text-decoration: none">
                            <div class="form-inline d-sm-block d-md-none">
                                <button class="btn btn-login  my-2 my-sm-0 px-4">Masuk</button>
                            </div>
                        </a>
                        <!-- Desktop Button -->
                        <a href="<?= site_url('auth') ?>">
                            <div class="form-inline my-2 my-lg-0 d-none d-md-block">
                                <button class="btn btn-login btn-navbar-right my-2 my-sm-0 px-4">Masuk</button>
                            </div>
                        </a>
                    </ul>
                </div>
            </nav>
        </div>
    </div>

    <main>
        <script src="<?= base_url('assets/') ?>frontend/libraries/jquery/jquery-3.4.1.min.js"></script>
        <?= $contents ?>
    </main>

    <div class="footer">
        <div class="container">
            Copyright &copy; <?= date('Y') ?> <?= $company['company_name'] ?> Developed By <a href="https://1112-project.com/" target="blank" style="text-decoration: none;">1112-Project</a>
        </div>
    </div>


    <script src="<?= base_url('assets/') ?>frontend/libraries/bootstrap/js/bootstrap.js"></script>

</body>

</html>
<?php $no_wa = indo_tlp($company['phonecode'] . $company['whatsapp']); ?>
<!-- GetButton.io widget -->
<script type="text/javascript">
    (function() {
        var options = {
            whatsapp: "<?php echo "$no_wa" ?>", // WhatsApp number
            call_to_action: "Kontak Kami", // Call to action
            position: "right", // Position may be 'right' or 'left'
        };
        var proto = document.location.protocol,
            host = "getbutton.io",
            url = proto + "//static." + host;
        var s = document.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = url + '/widget-send-button/js/init.js';
        s.onload = function() {
            WhWidgetSendButton.init(host, proto, options);
        };
        var x = document.getElementsByTagName('script')[0];
        x.parentNode.insertBefore(s, x);
    })();
</script>
<!-- /GetButton.io widget -->